/*--------------------------------------
   PATHS.C -- Win32 Paths Demo
              (c) Charles Petzold, 1992
  --------------------------------------*/

#include <windows.h>
#include <string.h>

LONG APIENTRY WndProc (HWND, UINT, DWORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     static char szAppName[] = "Paths" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Paths Demo",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

LONG APIENTRY WndProc (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static char * szOper  [] = { "Stroke, ", "Fill, ", "S & F, " } ;
     static char * szFill  [] = { "Alt", "Wind" } ;
     static char * szWiden [] = { "", " (Widened)" } ;
     static short  cxClient, cyClient ;
     HDC           hdc ;
     int           x, y ;
     PAINTSTRUCT   ps ;

     switch (message)
          {
          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
	       hdc = BeginPaint (hwnd, &ps) ;

                    // Define a logical display area

               SetMapMode (hdc, MM_ANISOTROPIC) ;
               SetWindowExtEx (hdc, 100, 100, NULL) ;
               SetViewportExtEx (hdc, cxClient / 4, cyClient / 3, NULL) ;

                    // Set text alignment and brush

               SetTextAlign (hdc, TA_UPDATECP) ;
               SelectObject (hdc, GetStockObject (LTGRAY_BRUSH)) ;

               for (x = 0 ; x < 4 ; x++)
               for (y = 0 ; y < 3 ; y++)
                    {
                         // Set the proper viewport origin

                    SetViewportOrgEx (hdc, x * cxClient / 4,
                                           y * cyClient / 3, NULL) ;

                         // Display text descriptions

                    MoveToEx (hdc, 0, 0, NULL) ;

                    TextOut (hdc, 0, 0, szOper [y],
                                strlen (szOper [y])) ;

                    TextOut (hdc, 0, 0, szFill [x % 2],
                                strlen (szFill [x % 2])) ;

                    TextOut (hdc, 0, 0, szWiden [x > 1],
                                strlen (szWiden [x > 1])) ;

                         // Create a path with an open and closed subpath

                    BeginPath (hdc) ;

                    MoveToEx (hdc, 10, 30, NULL) ;
                    LineTo   (hdc, 50, 70) ;
                    LineTo   (hdc, 90, 30) ;

                    MoveToEx (hdc, 10, 50, NULL) ;
                    LineTo   (hdc, 50, 90) ;
                    LineTo   (hdc, 90, 50) ;
                    CloseFigure (hdc) ;

                    EndPath (hdc) ;

                         // Possibly widen the path by a 10 width pen

                    if (x > 1)
                         {
                         SelectObject (hdc, CreatePen (PS_SOLID, 10, 0)) ;
                         WidenPath (hdc) ;
                         DeleteObject (
                              SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
                         }

                         // Set polygon filling mode

                    SetPolyFillMode (hdc, x % 2 ? WINDING : ALTERNATE) ;

                         // Stroke, fill, or stroke and fill the path

                    switch (y)
                         {
                         case 0:   StrokePath (hdc) ;         break ;
                         case 1:   FillPath (hdc) ;           break ;
                         case 2:   StrokeAndFillPath (hdc) ;  break ;
                         }
                    }

	       EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
